/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.ObjectBackground;
import com.ibm.hwmca.fw.ui.UIClientListener;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIListener;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectsConstants;
import com.ibm.hwmca.fw.ui.UIPropertyChangeEvent;
import com.ibm.hwmca.fw.ui.UIPropertyChangeSupport;
import com.ibm.hwmca.fw.ui.UITaskletRequests;
import com.ibm.hwmca.fw.ui.UITaskletResponses;
import com.ibm.hwmca.fw.ui.UserSettingsListener;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIClient
extends Client
implements UITaskletRequests,
UITaskletResponses,
UILog,
UIObjectsConstants {
    private static final String MSG_NOT_INIT = "UIClient is not initialized, call UIClient.init() before using this method.";
    private static final String EVENT_TASKLET_CLASS_NAME = "com.ibm.hwmca.fw.ui.UIEventTasklet";
    private HMCSession hmcSession;
    private boolean acceptableState;
    private Set allowedShortIds;
    private Map uiActions;
    private ObjectBackground objectBackground;
    private ArrayList userSettingsListeners;
    private ArrayList uiListeners;
    private UIPropertyChangeSupport propertyChangeSupport;
    private Integer taskletId;
    private Object uiListenersLock = new Object();
    private Object userSettingsListenersLock = new Object();
    private Object lock = new Object();
    private EventClient eventThread;
    private String backgroundImageName;
    private static final String TRACE_MASKT = "HUICLI T";
    private static final String TRACE_MASKF = "HUICLI F";
    private static final String TRACE_MASKD = "HUICLI D";

    UIClient(HMCSession hmcSession) throws TaskletException {
        super(EVENT_TASKLET_CLASS_NAME, null);
        this.hmcSession = hmcSession;
        Trace.trace(TRACE_MASKT, "<> UIClient.UIClient()");
    }

    public TaskletResponse init() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIClient.init()");
        TaskletResponse response = super.init();
        this.taskletId = (Integer)response.getData("TaskletId");
        this.backgroundImageName = (String)response.getData("BackgroundImageName");
        this.allowedShortIds = (Set)response.getData("AllowedShortIds");
        this.hmcSession.setSessionAttribute("com.ibm.hwmca.fw.settings.user.UserSettings", response.getData("UserSettings"));
        this.hmcSession.setSessionAttribute("com.ibm.hwmca.fw.ui.UIClient", this);
        this.objectBackground = new ObjectBackground((Map)response.getData("UserSettings"));
        this.objectBackground.setShortIdToStatusImageName((Map)response.getData("StatusImageNames"));
        this.objectBackground.setShortIdToAttnImageName((Map)response.getData("AttnTaskImageNames"));
        this.objectBackground.setShortIdToStatus((Map)response.getData("ShortIdToStatus"));
        this.objectBackground.setStatusToShortId((Map)response.getData("StatusToShortId"));
        this.acceptableState = (Boolean)response.getData("UnacceptableState") == false;
        this.uiActions = (Map)response.getData("UIActions");
        this.getEvents();
        Trace.trace(TRACE_MASKF, "   number of actions is " + this.uiActions.size());
        Trace.trace(TRACE_MASKF, "<- UIClient.init()");
        return response;
    }

    private void traceAttentionTaskImageNames(Map attentionTaskImageNames) {
        Trace.trace(TRACE_MASKF, "   attentionTaskImageNames Map is:");
        Iterator iterator = attentionTaskImageNames.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String val = (String)attentionTaskImageNames.get(key);
            Trace.trace(TRACE_MASKF, "   key [" + key + "], value [" + val + "]");
        }
    }

    private void traceStatusImageNames(Map statusImageNames) {
        Trace.trace(TRACE_MASKF, "   statusImageNames Map is:");
        Iterator iterator = statusImageNames.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String val = (String)statusImageNames.get(key);
            Trace.trace(TRACE_MASKF, "   key [" + key + "], value [" + val + "]");
        }
    }

    public synchronized TaskletResponse request(TaskletRequest request) throws TaskletException {
        return super.request(request);
    }

    public Map getUserSettings() throws IllegalStateException {
        Trace.trace(TRACE_MASKF, "<> UIClient.getUserSettings()");
        return (Map)this.hmcSession.getSessionAttribute("com.ibm.hwmca.fw.settings.user.UserSettings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserSettingsListener(UserSettingsListener listener) {
        Trace.trace(TRACE_MASKF, "-> UIClient.addUserSettingsListener()");
        Object object = this.userSettingsListenersLock;
        synchronized (object) {
            if (this.userSettingsListeners == null) {
                this.userSettingsListeners = new ArrayList();
            }
            this.userSettingsListeners.add(listener);
        }
        Trace.trace(TRACE_MASKF, "<- UIClient.addUserSettingsListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserSettingsListener(UserSettingsListener listener) {
        Trace.trace(TRACE_MASKF, "-> UIClient.removeUserSettingsListener()");
        Object object = this.userSettingsListenersLock;
        synchronized (object) {
            if (this.userSettingsListeners != null) {
                this.userSettingsListeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIClient.removeUserSettingsListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIClientListener(UIClientListener listener) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIClient.addUIClientListener()");
        Object object = this.uiListenersLock;
        synchronized (object) {
            if (this.uiListeners == null) {
                this.uiListeners = new ArrayList();
            }
            this.uiListeners.add(listener);
        }
        Trace.trace(TRACE_MASKF, "<- UIClient.addUIClientListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIClientListener(UIListener listener) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIClient.removeUIClientListener()");
        Object object = this.uiListenersLock;
        synchronized (object) {
            if (this.uiListeners != null) {
                this.uiListeners.remove(listener);
            }
        }
        this.stopEventLoop();
        Trace.trace(TRACE_MASKF, "<- UIClient.removeUIClientListener()");
    }

    public synchronized UIPropertyChangeSupport getUIPropertyChangeSupport() {
        Trace.trace(TRACE_MASKF, "<> UIClient.getUIPropertyChangeSupport()");
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new UIPropertyChangeSupport();
        }
        return this.propertyChangeSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getUIClientListeners() {
        List result = null;
        Object object = this.uiListenersLock;
        synchronized (object) {
            if (this.uiListeners != null && this.uiListeners.size() > 0) {
                result = (List)this.uiListeners.clone();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getUserSettingsListeners() {
        ArrayList result = null;
        Object object = this.userSettingsListenersLock;
        synchronized (object) {
            if (this.userSettingsListeners != null && this.userSettingsListeners.size() > 0) {
                result = (ArrayList)this.userSettingsListeners.clone();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatusImageNames() {
        Map result = null;
        Object object = this.lock;
        synchronized (object) {
            result = this.objectBackground.getShortIdToStatusImageName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatusForShortId(String shortId) {
        Status result = null;
        Object object = this.lock;
        synchronized (object) {
            result = (Status)this.objectBackground.getShortIdToStatus().get(shortId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatusToShortId() {
        Map result = null;
        Object object = this.lock;
        synchronized (object) {
            result = this.objectBackground.getStatusToShortId();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortIdForStatus(Status status) {
        String result = null;
        Object object = this.lock;
        synchronized (object) {
            result = (String)this.objectBackground.getStatusToShortId().get(status);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAttentionTaskImageNames() {
        Map result = null;
        Object object = this.lock;
        synchronized (object) {
            result = this.objectBackground.getShortIdToAttnImageName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getUIActionsForShortId(String shortId) {
        Trace.trace(TRACE_MASKF, "-> UIClient.getUIActionsForShortId(), shortId is " + shortId);
        Collection result = null;
        Object object = this.lock;
        synchronized (object) {
            result = (Collection)this.uiActions.get(shortId);
            if (result == null || result.size() == 0) {
                Trace.trace(TRACE_MASKF, "   there are no actions for this shortId");
            } else {
                Trace.trace(TRACE_MASKF, "   number of actions is " + result.size());
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIClient.getUIActionsForShortId()");
        return result;
    }

    public String getAnimatedImageForImage(String imageName) {
        Trace.trace(TRACE_MASKF, "<> UIClient.getAnimatedImageForImage()");
        return imageName.substring(0, imageName.lastIndexOf(".gif")) + "animated.gif";
    }

    public String getAnimatedImageForTask(String taskShortId) {
        Trace.trace(TRACE_MASKF, "-> UIClient.getAnimatedImageForTask()");
        if (taskShortId == null) {
            throw new IllegalArgumentException("Argument 'taskShortId' passed to UIClient.getAnimatedImageForTask() is null.");
        }
        String result = null;
        Map map = this.getAttentionTaskImageNames();
        String imageName = (String)map.get(taskShortId);
        if (imageName != null) {
            result = this.getAnimatedImageForImage(imageName);
        } else {
            Trace.trace(TRACE_MASKF, "   could not find image for " + taskShortId);
        }
        Trace.trace(TRACE_MASKF, "<- UIClient.getAnimatedImageForTask(), result is " + result);
        return result;
    }

    public List getUIBooks() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIClient.getUIBooks()");
        Client client = new Client("com.ibm.hwmca.fw.ui.UIQueryTasklet", null);
        client.init();
        TaskletRequest request = new TaskletRequest();
        request.setData("request", "GetUIBooks");
        TaskletResponse response = client.request(request);
        List result = (List)response.getData("UIBooks");
        client.terminate();
        Trace.trace(TRACE_MASKF, "<- UIClient.getUIBooks()");
        return result;
    }

    private void setAcceptableState(boolean acceptable) {
        Trace.trace(TRACE_MASKF, "<> UIClient.setAcceptableState(), acceptable is " + acceptable);
        this.acceptableState = acceptable;
    }

    public boolean isAcceptable() {
        return this.acceptableState;
    }

    public boolean isUnacceptable() {
        return !this.acceptableState;
    }

    public void toggleLock(String shortIds) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIClient.toggleLock(), shortIds is " + shortIds);
        Client client = new Client("com.ibm.hwmca.fw.ui.UIQueryTasklet", null);
        client.init();
        TaskletRequest request = new TaskletRequest();
        request.setData("request", "ToggleLock");
        request.setData("ShortId", shortIds);
        TaskletResponse response = client.request(request);
        client.terminate();
        Trace.trace(TRACE_MASKF, "<- UIClient.toggleLock()");
    }

    public String getBackgroundImageName() {
        return this.backgroundImageName;
    }

    public Map getAllowedTasksMap() {
        Trace.trace(TRACE_MASKF, "-> UIClient.getAllowedTasksMap()");
        Map result = null;
        try {
            Client client = new Client("com.ibm.hwmca.fw.ui.UIQueryTasklet", null);
            client.init();
            TaskletRequest request = new TaskletRequest();
            request.setData("request", "GetAllowedTasksMap");
            TaskletResponse response = client.request(request);
            result = (Map)response.getData("TaskShortIdsMap");
            client.terminate();
        }
        catch (TaskletException exc) {
            new FrameworkLog(UILog.logInfo, 1821, exc).log();
            result = new HashMap();
        }
        Trace.trace(TRACE_MASKF, "<- UIClient.getAllowedTasksMap()");
        return result;
    }

    synchronized void getEvents() throws TaskletException {
        this.eventThread = new EventClient(this);
        Thread thread = new Thread((Runnable)this.eventThread, "UIClient.EventClient");
        thread.start();
    }

    void stopEventLoop() throws TaskletException {
    }

    public Set getAllowedShortIds() {
        return this.allowedShortIds;
    }

    class EventClient
    implements Runnable {
        UIClient uiClient;

        EventClient(UIClient uiClient) {
            this.uiClient = uiClient;
        }

        public void run() {
            boolean logged = false;
            boolean getNextEvent = true;
            while (getNextEvent) {
                try {
                    TaskletRequest request = new TaskletRequest();
                    request.setData("UIRequestKey", "GetEvents");
                    TaskletResponse response = UIClient.this.request(request);
                    if (response.getData("Logoff") != null) {
                        Trace.trace(UIClient.TRACE_MASKF, "   user logged off, end UIClient");
                        getNextEvent = false;
                        continue;
                    }
                    List events = (List)response.getData("Events");
                    int size = 0;
                    if (events != null) {
                        size = events.size();
                    }
                    Trace.trace(UIClient.TRACE_MASKF, "   UIClient received " + size + " events");
                    for (int i = 0; i < size; ++i) {
                        UIPropertyChangeEvent event = (UIPropertyChangeEvent)events.get(i);
                        String propertyName = event.getPropertyName();
                        if (propertyName.equals("AllowedShortIds")) {
                            this.updateAllowedShortIds(event);
                            continue;
                        }
                        if (propertyName.equals("StatusImages")) {
                            this.setStatusImageNames((Map)event.getNewValue());
                            continue;
                        }
                        if (propertyName.equals("ShortIdToStatus")) {
                            this.setShortIdToStatus((Map)event.getNewValue());
                            continue;
                        }
                        if (propertyName.equals("AttnTaskImages")) {
                            this.setAttentionTaskImageNames((Map)event.getNewValue());
                            continue;
                        }
                        if (propertyName.equals("UIActions")) {
                            this.updateUIActions((Map)event.getNewValue());
                            continue;
                        }
                        if (propertyName.equals("InventoryProperty")) {
                            this.inventoryChange(event);
                            continue;
                        }
                        if (propertyName.equals("UserSettings")) {
                            this.userSettingsChanged(event);
                            continue;
                        }
                        this.changeEvent(event);
                    }
                }
                catch (Throwable thr) {
                    if (thr instanceof ThreadDeath) {
                        throw (ThreadDeath)thr;
                    }
                    Trace.trace(UIClient.TRACE_MASKF, thr);
                    if (logged) continue;
                    new FrameworkLog(UILog.logInfo, 1795, thr).log();
                    logged = true;
                }
            }
            this.uiClient.terminate();
        }

        void setStatusImageNames(Map names) {
            UIClient.this.objectBackground.setShortIdToStatusImageName(names);
        }

        void setAttentionTaskImageNames(Map names) {
            UIClient.this.objectBackground.setShortIdToAttnImageName(names);
            UIClient.this.traceAttentionTaskImageNames(names);
        }

        void setShortIdToStatus(Map map) {
            UIClient.this.objectBackground.setShortIdToStatus(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateAllowedShortIds(UIPropertyChangeEvent event) {
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            Object object = UIClient.this.lock;
            synchronized (object) {
                Set allowedShortIds = UIClient.this.getAllowedShortIds();
                String[] ids = newValue == null ? (String[])oldValue : (String[])newValue;
                for (int j = 0; j < ids.length; ++j) {
                    if (newValue == null) {
                        Trace.trace(UIClient.TRACE_MASKF, "   shortId " + ids[j] + " is no longer allowed in the current user context");
                        allowedShortIds.remove(ids[j]);
                        continue;
                    }
                    Trace.trace(UIClient.TRACE_MASKF, "   shortId " + ids[j] + " is now allowed in the current user context");
                    allowedShortIds.add(ids[j]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateUIActions(Map actions) {
            Object object = UIClient.this.lock;
            synchronized (object) {
                UIClient.this.uiActions.putAll(actions);
            }
        }

        void inventoryChange(UIPropertyChangeEvent event) {
            List listeners;
            Trace.trace(UIClient.TRACE_MASKF, "-> UIClient.inventoryChange()");
            String[] newValue = (String[])event.getNewValue();
            String[] oldValue = (String[])event.getOldValue();
            boolean add = true;
            if (newValue == null && oldValue != null) {
                add = false;
            }
            if ((listeners = this.uiClient.getUIClientListeners()) != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    UIClientListener l = (UIClientListener)iterator.next();
                    if (add) {
                        l.add(newValue);
                        continue;
                    }
                    l.remove(oldValue);
                }
            }
            Trace.trace(UIClient.TRACE_MASKF, "<- UIClient.inventoryChange()");
        }

        void changeEvent(UIPropertyChangeEvent event) {
            Trace.trace(UIClient.TRACE_MASKF, "-> UIClient.changeEvent()");
            String propertyName = event.getPropertyName();
            List listeners = this.uiClient.getUIClientListeners();
            if (listeners != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    UIClientListener l = (UIClientListener)iterator.next();
                    if (propertyName.equals("StateProperty")) {
                        boolean b = (Boolean)event.getNewValue();
                        this.uiClient.setAcceptableState(b);
                        l.acceptableStateChanged(b);
                        continue;
                    }
                    if (propertyName.equals("UIInfo")) {
                        Collection actions = ((UIInfo)event.getNewValue()).getUIActions();
                        if (actions == null || actions.size() == 0) {
                            UIClient.this.uiActions.remove(event.getSource());
                        } else {
                            UIClient.this.uiActions.put(event.getSource(), actions);
                        }
                        l.propertyChange(event);
                        continue;
                    }
                    l.propertyChange(event);
                }
            }
            if (UIClient.this.propertyChangeSupport != null) {
                UIClient.this.propertyChangeSupport.notifyPropertyChangeListener(event);
            }
            Trace.trace(UIClient.TRACE_MASKF, "<- UIClient.changeEvent()");
        }

        void userSettingsChanged(UIPropertyChangeEvent event) {
            Trace.trace(UIClient.TRACE_MASKF, "-> UIClient.userSettingsChanged()");
            UserSettings newValue = (UserSettings)event.getNewValue();
            UserSettings oldValue = (UserSettings)event.getOldValue();
            Map userSettings = (Map)UIClient.this.hmcSession.getSessionAttribute("com.ibm.hwmca.fw.settings.user.UserSettings");
            userSettings.put(newValue.getClass().getName(), newValue);
            List listeners = this.uiClient.getUserSettingsListeners();
            if (listeners != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ((UserSettingsListener)iterator.next()).userSettingsChanged(oldValue, newValue);
                }
            }
            Trace.trace(UIClient.TRACE_MASKF, "<- UIClient.userSettingsChanged()");
        }
    }
}

